/*=============================================================================}
{ This demo shows how to obtain list of checkpoints in document.               }
{ Key methods:                                                                 }
{ - GetFirstCheckpoint, GetNextCheckpoint;                                     }
{ - GetCheckpointInfo.                                                         }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  AnsiString Name;
  bool       RaiseEvent;
  int        Tag;
  // 1. Filling in RichView
  for (int i=1; i<4; i++)
  {
    RichView1->AddNamedCheckpoint(AnsiString("C")+IntToStr(i));
    RichView1->AddFmt("Chapter %d", ARRAYOFCONST((i)), 1,1);
    for (int j=0; j<30; j++)
      RichView1->AddNLATag("Bla - bla - bla - bla - bla - bla - bla - bla "
        "- bla - bla - bla - bla - bla - bla - bla - bla",0,0,0);
  }
  RichView1->AddNamedCheckpoint("END");
  RichView1->Format();
  // 2. Filling in the list of checkpoints
  TCheckpointData CheckpointData =  RichView1->GetFirstCheckpoint();
  while (CheckpointData)
  {
    RichView1->GetCheckpointInfo(CheckpointData, Tag, Name, RaiseEvent);
    // Tag and RaiseEvent will be discussed in next demos
    ListBox1->Items->Add(Name);
    CheckpointData = RichView1->GetNextCheckpoint(CheckpointData);
  }
  ListBox1->ItemIndex = 0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int CheckpointIndex = ListBox1->ItemIndex;
  if (CheckpointIndex==-1)
    return;
  RichView1->ScrollTo(RichView1->GetCheckpointY(CheckpointIndex));
}
//---------------------------------------------------------------------------